package gov.va.vinci.dart.mail;

public interface MailManager {
	void sendPlainMail(final String userLoginId, final String subject, final String text);
	void sendPlainMail1(final String userLoginId, final String subject, final String text) throws Exception;
	void sendPlainMailToEmailDest(final String recipient, final String subject, final String text);
	
	void sendHTMLMail(final String userLoginId, final String subject, final String text, final boolean bIncludePrefix);
	void sendHTMLMail1(final String userLoginId, final String subject, final String text) throws Exception;
	void sendHTMLMailToEmailDest(final String recipient, final String subject, final String text, final boolean bIncludePrefix);
	
	void sendPlainAndHTMLMail(final String userLoginId, final String subject, final String plainBody, final String htmlBody, final boolean bIncludePrefix);
	void sendPlainAndHTMLMail1(final String userLoginId, final String subject, final String plainBody, final String htmlBody) throws Exception;
	void sendPlainAndHTMLMailToEmailDest(final String recipient, final String subject, final String plainBody, final String htmlBody, final boolean bIncludePrefix);
	
	void sendPlainAndHTMLMailWithAttachment(final String userLoginId, final String subject, final String plainBody, final String htmlBody, final boolean bIncludePrefix, final String attachmentFilename);
	void sendPlainAndHTMLMailWithAttachment1(final String userLoginId, final String subject, final String plainBody, final String htmlBody, final String attachmentFilename) throws Exception;
	void sendPlainAndHTMLMailWithAttachmentToEmailDest(final String recipient, final String subject, final String plainBody, final String htmlBody, final boolean bIncludePrefix, final String attachmentFilename);
	
	void sendTLSMail();
}
